﻿/******************************************************************************************
*
* $$FileName		Topic Title Based Keywrod Generator.jsx
* $$Author			Mayank Agrawal
* $$Description	   This script inserts keywords for each topic based upon the topic
*                                    title
*
*******************************************************************************************/


//* Do not change these values
var TAGMETA = 65584;


main();
function main()
{
	//Check if the project is open or not
	if(RoboHelp.project != undefined)
	{
		ProcessProject();
	}
	else
		alert("Open Project and then run the script");
}

function msg(szString)
{
	RoboHelp.project.outputMessage (szString);
}

function ProcessProject()
{
	msg("\n\n\nStarted processing the project.............\n");
	//parse though every thing and count the words
	var tpMgr = RoboHelp.project.TopicManager;
	msg("===============Started Traversing Topics now==================");
	TraverseManager(tpMgr,true);
	msg("\n=========================================================");
}

function TraverseManager(mgr,bTopic)
{
	for(var index=1;index<=mgr.count;index++)
	{
		//for each item, get the file path and count words	
		var topic = mgr.item(index);
		if(bTopic)
		{
            msg("\nProcessing " + topic.filename);
            ProcessTopic(topic);
         }
	}
}

function ProcessTopic(topic)
{
	var bSave = true;
	var strMarkerName = "";
	var strMarkerText = "";
	var strProjectPath = RoboHelp.project.path;
    var bFirstMetaTagFound = false;
    var firstMetaToken = null;
    var keywordMetaToken = null;
    var strKeywords = "";
	var filepath = strProjectPath + "\\" + topic.filename;
    
	// Get token manager
	var tknmgr = RoboHelp.getTokenManager(filepath);

	if (tknmgr != null)
	{
		var bResize = false;
		var bReplace = false;
		for(index=1;index<=tknmgr.count;index++)
		{
			var token = tknmgr.item(index);			
			
            if(!bFirstMetaTagFound)
            {
                    //Check if  this tag<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                    if(firstMetaToken == null && token.tokenType == RoboHelp.TokenType.TOKENTAG && token.tagType == TAGMETA)
				{
                         var strMetaName = token.getAttribute("http-equiv");
                         if(strMetaName != null && strMetaName != "")
                         {
                            firstMetaToken = token;
                            bFirstMetaTagFound = true;
                          }
                   }
            }
            else
            {
                 if(keywordMetaToken == null && token.tokenType == RoboHelp.TokenType.TOKENTAG && token.tagType == TAGMETA)
                 {
                     var strMetaName = token.getAttribute("name");
                     if(strMetaName == "search-keywords")
                     {
                        keywordMetaToken = token;
                        strKeywords = token.getAttribute("content");
                        var keywordExist = strKeywords.indexOf(topic.name);
                        if(keywordExist != -1)
                            bSave = false;
                        else
                            strKeywords += ", ";
                      }
                 }
            }
		}
	}

	if(bSave)
	{
          strKeywords += topic.name;
          if(keywordMetaToken != null)
            keywordMetaToken.setAttribute("content", strKeywords);
         else if (firstMetaToken != null)
         {
            var strKeywordTokenText = "<meta name=\"search-keywords\" content=\"" + strKeywords + "\"/>";
            firstMetaToken.insertText(strKeywordTokenText);
          }
		msg(" [UPDATED]");
		tknmgr.save();
	}
	return;
}